<?php

/**
 * To activate this extension, add the following into your LocalSettings.php file:
 * require_once('$IP/extensions/anacode.php');
 */
 
/**
 * Protect against register_globals vulnerabilities.
 * This line must be present before any global variable is referenced.
 */
if( !defined( 'MEDIAWIKI' ) ) {
        echo( "This is an extension to the MediaWiki package and cannot be run standalone.\n" );
        die( -1 );
}
 
// Extension credits that will show up on Special:Version    
$wgExtensionCredits['specialpage'][] = array(
        'name' => 'Anacode',
        'version' => 0.6,
        'author' => 'Juha Villman',
        'url' => 'http://en.opasnet.org/w/extension:anacode',
        'description' => 'Displays Analytica code in wiki as a preformatted text',
        'descriptionmsg' => 'foobar-desc',
);
 
//Avoid unstubbing $wgParser on setHook() too early on modern (1.12+) MW versions, as per r35980
if ( defined( 'MW_SUPPORTS_PARSERFIRSTCALLINIT' ) ) {
        $wgHooks['ParserFirstCallInit'][] = 'efAnacodeParserInit';
} else { // Otherwise do things the old fashioned way
        $wgExtensionFunctions[] = 'efAnacodeParserInit';
}
 
function efAnacodeParserInit() {
        global $wgParser;
        $wgParser->setHook( 'anacode', 'efAnacodeRender' );
        return true;
}
 
function efAnacodeRender( $input, $args, $parser ) {
	//we just add class to input and that's it...
	$input="<pre class=\"_fck_mw_lspace\">".$input."</pre>";
    return $input;
}
